#include "General.h"
#include "FlamingC4Prevention.h"
#include "slist.h"
#include "VehicleGameObj.h"
#include "GameObjManager.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

int TimedC4Limit;
int RemoteC4Limit;
int ActivationWaitTime; // How long to wait before the timer that starts the actual script expires

StringClass PageMessage; // General page message that gets sent to players if their C4 get disarmed
StringClass TimedC4LimitMessage; // More specific stuff
StringClass RemoteC4LimitMessage;
StringClass TimedC4StackedMessage;
StringClass RemoteC4StackedMessage;

int TimedC4Stacked;  // Limit of allowed stacked Timed C4
int RemoteC4Stacked; // Limit of allowed stacked Remote C4

bool Is_C4(GameObject* obj)
{
	if (!obj)
	{
		return false;
	}
	if (!Commands->Get_ID(obj))
	{
		return false;
	}
	if (!obj->As_PhysicalGameObj())
	{
		return false;
	}
	if (obj->As_PhysicalGameObj()->As_C4GameObj())
	{
		return true;
	}
	return false;
}

void Page(int ID, const char *Format, ...)
{
	if(ID < 1 || ID > 128)
	{
		return;
	}

	if (!Get_GameObj(ID))
	{
		return;
	}

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if(Version < 2.9)
	{
		Console("ppage %d %s", ID, buffer);
		return;
	}
	else
	{
		Console("cmsgp %d 205,140,0 %s", ID, buffer);
	}
}

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

// C4 mode for a C4GameObj, 1 = remote, 2 = timed, 3 = proximity, anything else is invalid
int Get_C4_Count_Empty_vehicles(int PlayerID, int C4Mode) 
{
	int count = 0;
	SLNode<BaseGameObj> *x = GameObjManager::GameObjList.Head();
	while (x) 
	{
		GameObject *o = (GameObject *)x->Data();
		if (Is_C4(o) && Get_C4_Mode(o) == C4Mode)
		{
			if (Get_Player_ID(Get_C4_Planter(o)) == PlayerID)
			{
				GameObject* objectattached = Get_C4_Attached(o);
				int attached_team = Commands->Get_Player_Type(objectattached);
				if ((attached_team != 1) && (attached_team != 0) && objectattached->As_VehicleGameObj() && (Get_Vehicle_Occupant_Count(objectattached) < 1) )
						count++;
			}
		}
		x = x->Next();
	}
	return count;
}

// C4 mode for a C4GameObj, 1 = remote, 2 = timed, 3 = proximity, anything else is invalid
int Get_C4_Count_Stacked_C4(int PlayerID, int C4Mode) 
{
	int myteam = Commands->Get_Player_Type(Get_GameObj(PlayerID));
	int count = 0;
	SLNode<BaseGameObj> *x = GameObjManager::GameObjList.Head();
	while (x) 
	{
		GameObject *o = (GameObject *)x->Data();
		if (Is_C4(o) && Get_C4_Mode(o) == C4Mode)
		{
			if (Get_Player_ID(Get_C4_Planter(o)) == PlayerID)
			{
				GameObject* objectattached = Get_C4_Attached(o);
				if ( !objectattached ) { continue; }

				int attached_team = Commands->Get_Player_Type(objectattached);
				if (myteam== attached_team && Is_C4(objectattached) )
						count++;
			}
		}
		x = x->Next();
	}
	return count;
}

FlamingC4Prevention::FlamingC4Prevention()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

FlamingC4Prevention::~FlamingC4Prevention()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

void FlamingC4Prevention::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
	SSGMIni->Get_String(PageMessage, "FlamingC4Prevention", "PageMessage", 
		"Your C4 has been automatically disarmed by the \"Flaming C4\" prevention script.");
	SSGMIni->Get_String(TimedC4LimitMessage, "FlamingC4Prevention", "TimedC4LimitMessage", 
		"You placed too many Timed C4 on empty vehicle(s), your last one has been disarmed.");
	SSGMIni->Get_String(RemoteC4LimitMessage, "FlamingC4Prevention", "RemoteC4LimitMessage", 
		"You placed too many Remote C4 on empty vehicle(s), your last one has been disarmed.");
	SSGMIni->Get_String(TimedC4StackedMessage, "FlamingC4Prevention", "TimedC4StackedMessage", 
		"Your last Timed C4 has been disarmed, please don't place C4 on top of each other.");
	SSGMIni->Get_String(RemoteC4StackedMessage, "FlamingC4Prevention", "RemoteC4StackedMessage", 
		"Your last Remote C4 has been disarmed, please don't place C4 on top of each other.");

	TimedC4Limit = SSGMIni->Get_Int("FlamingC4Prevention", "TimedC4Limit", 3);
	RemoteC4Limit = SSGMIni->Get_Int("FlamingC4Prevention", "RemoteC4Limit", 6);
	TimedC4Stacked = SSGMIni->Get_Int("FlamingC4Prevention", "TimedC4Stacked", 1);
	RemoteC4Stacked = SSGMIni->Get_Int("FlamingC4Prevention", "RemoteC4Stacked", 2);
	ActivationWaitTime = SSGMIni->Get_Int("FlamingC4Prevention", "ActivationWaitTime", 2);
}

void FlamingC4Prevention::OnObjectCreate(void *data,GameObject *obj)
{
	if (obj->As_PhysicalGameObj() && obj->As_PhysicalGameObj()->As_C4GameObj()) 
	{
		Attach_Script_Once(obj, "Iran_Flaming_C4_Prevention", "");
	}
}

void Iran_Flaming_C4_Prevention::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this, (float)ActivationWaitTime, 1);
}

void Iran_Flaming_C4_Prevention::Timer_Expired(GameObject *obj, int number)
{
	if (!obj || !Get_C4_Planter(obj) || !Get_C4_Attached(obj)) return;

	int C4OwnerID = Get_Player_ID(Get_C4_Planter(obj));
	GameObject* ObjectAttached = Get_C4_Attached(obj);

	int C4OwnerTeam = Commands->Get_Player_Type(Get_C4_Planter(obj));
	int AttachedTeam = Commands->Get_Player_Type(ObjectAttached);

	if (strstr(Commands->Get_Preset_Name(ObjectAttached), "pct")) // do nothing if attached to purchase terminal
	{
		return;
	}

	if (C4OwnerTeam == AttachedTeam && !ObjectAttached->As_BuildingGameObj() && !Is_C4(ObjectAttached))
	{
		Page(C4OwnerID, PageMessage);
		Disarm_C4(obj);
	}

	else if ((AttachedTeam != 1) && (AttachedTeam != 0) && ObjectAttached->As_VehicleGameObj() && (Get_Vehicle_Occupant_Count(ObjectAttached) < 1) ) 
	{
		// Attached to a 'friendly' unit that's empty (e.g. all empty ones and those !lock'd)	
		if (Get_C4_Mode(obj) == 3)  // Proxy C4
		{ 
			Page(C4OwnerID, PageMessage);
			Disarm_C4(obj);
		}
		else if (Get_C4_Mode(obj) == 1) // Remote C4
		{ 
			if (Get_C4_Count_Empty_vehicles(C4OwnerID, 1) > RemoteC4Limit) 
			{
				Page(C4OwnerID, RemoteC4LimitMessage);
				Disarm_C4(obj);
			}
		}
		else if (Get_C4_Mode(obj) == 2) // Timed C4
		{ 
			if ( Get_C4_Count_Empty_vehicles(C4OwnerID, 2) > TimedC4Limit) 
			{
				Page(C4OwnerID, TimedC4LimitMessage);
				Disarm_C4(obj);
			}
		}
	}
	else if (C4OwnerTeam == AttachedTeam && Is_C4(ObjectAttached)) // Attached to a friendly C4
	{ 
		if (Get_C4_Mode(obj) == 1) 
		{
			if (Get_C4_Count_Stacked_C4(C4OwnerID, 1) > RemoteC4Stacked) 
			{
				Page(C4OwnerID, RemoteC4StackedMessage);
				Disarm_C4(obj);
			}
		}
		else if (Get_C4_Mode(obj) == 2) 
		{
			if (Get_C4_Count_Stacked_C4(C4OwnerID, 2) > TimedC4Stacked) 
			{
				Page(C4OwnerID, TimedC4StackedMessage);
				Disarm_C4(obj);
			}
		}
	}
}

ScriptRegistrant<Iran_Flaming_C4_Prevention> Iran_Flaming_C4_Prevention_Registrant("Iran_Flaming_C4_Prevention","");

FlamingC4Prevention flamingC4Prevention;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &flamingC4Prevention;
}
